<?php
// toggle_whatsapp.php
$cfgPath = getenv('MONITOR_CONFIG_FILE') ?: rtrim(getenv('MONITOR_BASE') ?: '/home/monitor', '/') . '/monitor_config.json';
$arg = $argv[1] ?? null;
if (!in_array($arg, ['on','off'], true)) {
    echo "Usage: php toggle_whatsapp.php on|off\n";
    exit(1);
}
$val = $arg === 'on' ? true : false;
$data = ['enable_whatsapp' => $val];
if (file_put_contents($cfgPath, json_encode($data, JSON_PRETTY_PRINT))) {
    echo "Wrote {$cfgPath}: enable_whatsapp = " . ($val ? 'true' : 'false') . PHP_EOL;
    exit(0);
} else {
    echo "Failed to write {$cfgPath}. Check permissions.\n";
    exit(2);
}
?>
