# Monitor Bot (PHP) - Package

This package contains a pure-PHP website monitoring setup for:
- Page speed checks (mobile + desktop)
- Synthetic checkout flow checks up to payment provider detection
- Alerts via Mailgun (Email) and Gupshup (WhatsApp)
- Runtime toggle for WhatsApp notifications

## Files
- monitor_helpers.php — shared helpers (Mailgun + Gupshup + toggle)
- pagespeed_check.php — PageSpeed Insights runner + alerting
- synthetic_check.php — Synthetic checkout runner (Shopify-focused)
- toggle_whatsapp.php — CLI to toggle WhatsApp on/off
- monitor_config.json — runtime config (enable_whatsapp)
- crontab.sample — sample cron lines
- run_pagespeed.sh, run_synthetic.sh — wrapper scripts for cron (create manually)
- README.md — this file

## Setup (quick)
1. Copy files to server, e.g. `/home/monitor`.
2. Set environment variables (example):
   - `MONITOR_BASE=/home/monitor`
   - `SITE_URL=https://shop.tagdaraho.in`
   - `TEST_PRODUCT_URL=https://shop.tagdaraho.in/products/your-product`
   - Mailgun: `MAILGUN_API_KEY`, `MAILGUN_DOMAIN`, `ALERT_EMAIL_FROM`, `ALERT_EMAIL_TO`
   - Gupshup: `GUPSHUP_API_KEY`, `GUPSHUP_SOURCE`, `ALERT_WHATSAPP_TO`
   - `PAGESPEED_API_KEY`
3. Make sure the monitor user can write to MONITOR_BASE.
4. Test scripts manually:
   - `php pagespeed_check.php`
   - `php synthetic_check.php`
5. Add cron entries (sample in crontab.sample).

## Notes & limitations
- The synthetic checkout is a *server-side* best-effort script. If the checkout relies on client-side JavaScript to create tokens or do redirects, a headless browser (Selenium/Puppeteer) is required for full end-to-end testing.
- Do not commit secrets to this folder. Use environment variables or a secure secret store.

If you want, I can:
- adapt the detection rules for Gokwick if you provide their callback/redirect host,
- add PHPMailer SMTP fallback,
- create a one-file web UI for toggling WhatsApp (protected).

